<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $item)): ?>
        <li>
            <a href="<?php echo e(route('c-panel.bills.edit', $item->id)); ?>" class="dropdown-item edit-item-btn">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Edit')); ?>

            </a>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $item)): ?>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-<?php echo e($item->id); ?>">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Delete')); ?>

            </a>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin', App\Models\User::class)): ?>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#update-status<?php echo e($item->id); ?>">
                <i class="ri-tools-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Update Status')); ?>

            </a>
        </li>
        <?php endif; ?>
    </ul>
</div>


<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $item)): ?>
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" <?php echo e(route('c-panel.bills.destroy',$item->id)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                            <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Remove this Record ?')); ?></p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin', App\Models\User::class)): ?>
<div class="modal fade" id="update-status<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Update Status')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
            </div>
            <form action="<?php echo e(route('c-panel.bills.update-status', $item->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label"><?php echo e(__('Status')); ?></label>
                        <select name="status" id="status<?php echo e($item->id); ?>" class="form-select">
                            
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="hstack gap-2 justify-content-end">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-success" id="add-btn"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/crmdivvat/public_html/resources/views/admin/bills/datatable/buttons.blade.php ENDPATH**/ ?>