<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        
        <li>
            <a href="<?php echo e(route('c-panel.offers.edit', $item->id)); ?>" class="dropdown-item edit-item-btn">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Edit')); ?>

            </a>
        </li>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-<?php echo e($item->id); ?>">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Delete')); ?>

            </a>
        </li>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#update-status<?php echo e($item->id); ?>">
                <i class="ri-tools-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Update Status')); ?>

            </a>
        </li>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#convert-invoice-<?php echo e($item->id); ?>">
                <i class="ri-refresh-line align-bottom me-2 text-muted"></i> <?php echo e(__('Convert to Invoice')); ?>

            </a>
        </li>
    </ul>
</div>


<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" <?php echo e(route('c-panel.offers.destroy',$item->id)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                            <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Remove this Record ?')); ?></p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->


<div class="modal fade" id="update-status<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Update Status')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
            </div>
            <form action="<?php echo e(route('c-panel.offers.update-status', $item->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label"><?php echo e(__('Status')); ?></label>
                        <select name="status" id="status<?php echo e($item->id); ?>" class="form-select">
                            <option <?php if($item->status == 0): ?> selected <?php endif; ?> value="0"><?php echo e(__('New Offer')); ?></option>
                            <option <?php if($item->status == 1): ?> selected <?php endif; ?> value="1"><?php echo e(__('Under Review')); ?></option>
                            <option <?php if($item->status == 2): ?> selected <?php endif; ?> value="2"><?php echo e(__('Under Update')); ?></option>
                            <option <?php if($item->status == 3): ?> selected <?php endif; ?> value="3"><?php echo e(__('Accepted')); ?></option>
                            <option <?php if($item->status == 4): ?> selected <?php endif; ?> value="4"><?php echo e(__('Rejected')); ?></option>
                            <option <?php if($item->status == 5): ?> selected <?php endif; ?> value="5"><?php echo e(__('Canceled')); ?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="hstack gap-2 justify-content-end">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-success" id="add-btn"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Delete Modal -->
<div class="modal fade zoomIn" id="convert-invoice-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" <?php echo e(route('c-panel.offers.update-status',$item->id)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="status" value="6">
                    <div class="mt-2 text-center">
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                            <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Convert?')); ?></p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn w-sm btn-success " id="delete-record"><?php echo e(__('Yes, Convert It!')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
<?php /**PATH C:\Users\Ahmed\Documents\GitHub\crm-panel\resources\views/admin/offers/datatable/buttons.blade.php ENDPATH**/ ?>