@extends('front.layout.app')

@section('title')
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.home'] }}@else{{ $menu['en']['view.home'] }}
    @endif
@stop
 

@section('content')
<div id="slider" class="inspiro-slider background-black" data-height-xs="360">
   <div class="slide" style="background-image:url('{{ asset('storage/' . ($main_slider->image ?? '')) }}');">
      <div class="bg-overlay" data-style="10"></div>
      <div class="container">
         <div class="slide-captions text-center text-light">
            <h3>  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                {{ $main_slider->title_ar }}@else{{ $main_slider->title }}
                @endif  </h3>
            <h2><span class="text-rotator" data-animation="flip" data-speed="5000"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
                {{ $main_slider->sub_title_ar }}@else{{ $main_slider->sub_title }}
                @endif  </span></h2>
            <button type="button" class="btn btn-danger" data-target="#modal-2" data-toggle="modal" href="#"><span class="btn-label"><i class="fa fa-check"></i></span>احصل على عرض أسعار</button>
         </div>
      </div>
   </div>
</div>
<div class="modal fade" id="modal-2" tabindex="-1" role="modal" aria-labelledby="modal-label-2" aria-hidden="true">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header">
            <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
            <h2 class="m-t-10 m-b-10">ابق على تواصل معنا</h2>
            <p class="m-b-0 p-b-0">هذا النص هو مثال لنص يمكن أن يستبدل في نفس المساحة، لقد تم توليد هذا النص من مولد النص العربى،
               حيث يمكنك أن تولد مثل هذا النص أو العديد من النصوص الأخرى إضافة إلى زيادة عدد الحروف التى يولدها التطبيق. 
            </p>
         </div>
         <div class="modal-body">
            <form class="widget-contact-form" novalidate action="include/contact-form.php.json" role="form" method="post">
               <div class="row">
                  <div class="form-group col-lg-6">
                     <label for="name">الاسم</label>
                     <input type="text" aria-required="true" name="widget-contact-form-name" class="form-control required name" placeholder="أدخل أسمك">
                  </div>
                  <div class="form-group col-lg-6">
                     <label for="email">البريد الإلكتروني</label>
                     <input type="email" aria-required="true" required name="widget-contact-form-email" class="form-control required email" placeholder="أدخل بريدك الإلكتروني">
                  </div>
               </div>
               <div class="form-group">
                  <label for="message">رسالة</label>
                  <textarea type="text" name="widget-contact-form-message" rows="8" class="form-control required" placeholder="أدخل رسالتك"></textarea>
               </div>
               <div class="form-group">
                  <button class="btn btn-light" type="submit" id="form-submit"><i class="fa fa-paper-plane"></i>&nbsp;أرسل رسالة</button>
               </div>
            </form>
         </div>
      </div>
   </div>
</div>
<section class="background-black">
   <div class="container">
      <div class="portfolio">
         <nav class="grid-filter gf-outline gf-light" data-layout="#portfolio">
            <ul>
               <li class = "active"> <a href="#" data-category="*"> إظهار الكل </a> </li>
               @foreach ($categories as $category)
               <li> <a href="#" data-category=".c{{ $category->id }}">{{ $category->title_ar }}</a> </li>
               @endforeach 
            </ul>
         </nav>
         <div id="portfolio" class="grid-layout portfolio-4-columns" data-margin="10">
            @foreach ($categories as $category) 
            @foreach ($category->workes as $item)
            <div class="portfolio-item img-zoom c{{ $category->id }}">  
                <div class="portfolio-item-wrap">
                    <div class="portfolio-image">
                       <a href="{{ route('view.work',$item->id )}}"><img src="{{ asset('storage/works/' . ($item->image ?? '')) }}" alt=""></a>
                    </div>
                    <div class="portfolio-description">
                        @if ($item->v_link)
                        <a title="Paper Pouch!" data-lightbox="iframe" href="{{$item->v_link}}"><i class="fa fa-play"></i></a>
                        @endif 
                        <a href="{{ route('view.work',$item->id )}}">
                          <h3>@if (LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $item->title_ar }}@else{{ $item->title }}
                            @endif
                          </h3> 
                       </a>
                    </div>
                 </div> 
            </div>
            @endforeach 
            @endforeach 
             
         </div>
      </div>
   </div>
</section>
     
@endsection

@section('js')
    
@endsection

