@extends('front.layout.app')

@section('title')
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.about'] }}@else{{ $menu['en']['view.about'] }}
    @endif
@stop
 

@section('content')
<section id="page-title" data-bg-parallax="{{ asset('front/images/14.jpg')}}">
    <div class="bg-overlay"></div>
    <div class="container">
    <div class="page-title">
    <h1 class="text-uppercase text-medium">  @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.about'] }}@else{{ $menu['en']['view.about'] }}
    @endif   </h1>
    </div>
        <div class="breadcrumb mt-5">
            <ul>
                <li> <a href="{{ route('view.home') }}"> الصفحة الرئيسية </a> </li> 
                <li class="active"> <a >  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                    {{ $menu['ar']['view.about'] }}@else{{ $menu['en']['view.about'] }}
                @endif   </a> </li>
            </ul>
        </div>
    </div>
    </section>
    
    <section class="background-dark">
    <div class="container">
    <div class="row">
        <div class="col-sm-12 col-lg-4">
    
            <img class="img-fluid" src="{{ asset('storage/works/' . ($about->image ?? '')) }}" height="456" width="780"/>
        </div>
    <div class="col-lg-8">
    <div class="heading-text heading-section">
    <h2>@if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $about->title_ar }}@else{{ $about->title }}
    @endif</h2>
    <p class="lead">
        @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $about->description_ar }}@else{{ $about->description }}
    @endif
    </p>
    
    </div>
    </div>
    </div>
    </div>
    </section>
    <section class="background-dark">
    <div class="container">
    <div class="heading-text heading-section text-center">
    <h2> فريقنا </h2>
    </div>
    <div class="row team-members team-members-shadow m-b-40">
        @foreach($teams as $team)
    <div class="col-lg-3">
    <div class="team-member">
    <div class="team-image">
    <img src="{{ asset('storage/'.$team->image) }}">
    </div>
    <div class="team-desc">
        <h3>  @if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $team->name_ar }}@else{{ $team->name }}
        @endif</h3>
        <span>  @if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $team->position_ar }}@else{{ $team->position }}
        @endif</span> 
    </div>
    </div>
    </div>
    @endforeach 
    </div>
    </div>
    </section>
    <section class="background-dark">
    <div class="container">
    <div class="heading-text heading-section text-center">
        <h2>@if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $about->sub_title_ar }}@else{{ $about->sub_title }}
        @endif</h2>
    </div>
    <div class="row">
    <div class="col-lg-4">
    <div> 
    <p>@if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $about->mission_ar }}@else{{ $about->mission }}
    @endif </p>
    </div>
    </div>
    <div class="col-lg-4">
     <div> 
    <p> @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $about->message_ar }}@else{{ $about->message }}
    @endif</p>
    </div>
    </div>
    <div class="col-lg-4">
    <div> 
    <p>@if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $about->vision_ar }}@else{{ $about->vision }}
    @endif </p>
    </div>
    </div>
     
    </div>
    </div>
    </section class=" text-center">
    <section class="background-dark">
    <div class="container">
    <div class="row">
    <div class="col-md-12 text-center">
    <p class="lead">عملائنا الرائعين كان من دواعي سرورنا العمل معهم!</p>
    </div>
    </div>
    <ul class="grid grid-5-columns">
        @foreach ($partners as $partner)
        <li>
            <a href="#"><img src="{{ asset('storage/works/'.$partner->image)}}" alt="">
            </a>
            </li>
        @endforeach
     
    </ul>
    </div>
    </section>
    
     
@endsection

@section('js')
    
@endsection

