@extends('admin.layout.app')
@section('pageTitle')

@stop

@section('css')

<style>
    div.dataTables_wrapper div.dataTables_filter {
        float: left !important;
    }
    div.dataTables_wrapper div.dataTables_paginate {
        float: left !important;
    }
</style>
@stop

@section('content')
<div class="profile-foreground position-relative mx-n4 mt-n4">
    <div class="profile-wid-bg">
        <img src="{{ asset('assets/images/profile-bg.jpg') }}" alt="" class="profile-wid-img" />
    </div>
</div>
<div class="pt-4 mb-4 mb-lg-3 pb-lg-4">
    <div class="row g-4">
        <div class="col-auto">
            <div class="avatar-lg">
                <img src="{{ $customer->image ? asset('storage/'.$customer->image) : 'https://ui-avatars.com/api/?name=' . $customer->name }}" alt="user-img" class="img-thumbnail rounded-circle" />
            </div>
        </div>
        <!--end col-->
        <div class="col">
            <div class="p-2">
                <h3 class="text-white mb-1">{{ $customer->name }}</h3>
                <p class="text-white-75">{{ $customer->department->name ?? __('حساب جديد') }}</p>
                <div class="hstack text-white-50 gap-1">
                    <div class="me-2"><i class="ri-map-pin-user-line me-1 text-white-75 fs-16 align-middle"></i>{{ $customer->city ?? __('No Add City') }}, {{ $customer->country ?? __('No Add Country') }}</div>
                </div>
            </div>
        </div>
        <!--end col-->
        <div class="col-12 col-lg-auto order-last order-lg-0">
            <div class="row text text-white-50 text-center">
                <div class="col-lg-4 col-4">
                    <div class="p-2">
                        <h4 class="text-white mb-1">{{ App\Models\Subscription::where('type', '0')->where('user_id', $customer->id)->count() }}</h4>
                        <p class="fs-14 mb-0">{{ __('Services') }}</p>
                    </div>
                </div>
                <div class="col-lg-4 col-4">
                    <div class="p-2">
                        <h4 class="text-white mb-1">{{ App\Models\Subscription::where('type', '1')->where('user_id', $customer->id)->count() }}</h4>
                        <p class="fs-14 mb-0">{{ __('Domins') }}</p>
                    </div>
                </div>
                <div class="col-lg-4 col-4">
                    @php
                        $bills = App\Models\Bill::where('status', 1)->where('customer_id', $customer->id)->get();
                        $price = 0;
                        foreach ($bills as $key => $bill) {
                            # code...
                            $price += $bill->totel;
                        }
                    @endphp
                    <div class="p-2">
                        <h4 class="text-white mb-1">{{ $price }}</h4>
                        <p class="fs-14 mb-0">{{ __('Deserved Amount') }}</p>
                    </div>
                </div>
            </div>
        </div>
        <!--end col-->

    </div>
    <!--end row-->
</div>

<div class="row">
    <div class="col-lg-12">
        <div>
            <div class="d-flex">
                <!-- Nav tabs -->
                <ul class="nav nav-pills animation-nav profile-nav gap-2 gap-lg-3 flex-grow-1" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link fs-14 active" data-bs-toggle="tab" href="#overview-tab" role="tab">
                            <i class="ri-airplay-fill d-inline-block d-md-none"></i> <span class="d-none d-md-inline-block">{{ __('Personal Information') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link fs-14" data-bs-toggle="tab" href="#services" role="tab">
                            <i class="ri-price-tag-line d-inline-block d-md-none"></i> <span class="d-none d-md-inline-block">{{ __('Services') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link fs-14" data-bs-toggle="tab" href="#domains" role="tab">
                            <i class="ri-folder-4-line d-inline-block d-md-none"></i> <span class="d-none d-md-inline-block">{{ __('Domins') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link fs-14" data-bs-toggle="tab" href="#bills" role="tab">
                            <i class="ri-folder-4-line d-inline-block d-md-none"></i> <span class="d-none d-md-inline-block">{{ __('Invoices') }}</span>
                        </a>
                    </li>
                </ul>
                <div class="flex-shrink-0">
                    <a href="javascript:;" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#editSeller{{ $customer->id }}"><i class="ri-edit-box-line align-bottom"></i> {{ __('Edit Information') }}</a>
                </div>
            </div>
            <!-- Tab panes -->
            <div class="tab-content pt-4 text-muted">
                <div class="tab-pane active" id="overview-tab" role="tabpanel">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="table-responsive">
                                                <table class="table table-borderless mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Name') }} :</th>
                                                            <td class="text-muted">{{ $customer->name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Department') }} :</th>
                                                            <td class="text-muted">{{ $customer->department->name ?? __('حساب جديد') }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Association') }} :</th>
                                                            <td class="text-muted">{{ $customer->association ?? __('No Added') }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Phone Number') }} :</th>
                                                            <td class="text-muted">{{ $customer->phone ?? __('No Added') }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Created Date') }} :</th>
                                                            <td class="text-muted">{{ Carbon\Carbon::parse($customer->created_at)->format('Y-m-d') }}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="table-responsive">
                                                <table class="table table-borderless mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Country') }} :</th>
                                                            <td class="text-muted">{{ $customer->country ?? __('No Add Country') }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('City') }} :</th>
                                                            <td class="text-muted">{{ $customer->city ?? __('No Add City') }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Email') }} :</th>
                                                            <td class="text-muted">{{ $customer->email }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th class="ps-0" scope="row">{{ __('Website') }} :</th>
                                                            <td class="text-muted">{{ $customer->website ?? __('No Added') }}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div><!-- end card -->

                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <div class="tab-pane fade" id="services" role="tabpanel">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <table id="services-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>{{ __('ID') }}</th>
                                                <th>{{ __('Name') }}</th>
                                                <th>{{ __('End Date') }}</th>
                                                <th>{{ __('Price') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Payment Status') }}</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div><!-- end card body -->
                            </div><!-- end card -->

                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <!--end tab-pane-->
                <div class="tab-pane fade" id="domains" role="tabpanel">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <table id="domains-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>{{ __('ID') }}</th>
                                                <th>{{ __('Name') }}</th>
                                                <th>{{ __('End Date') }}</th>
                                                <th>{{ __('Price') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Payment Status') }}</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div><!-- end card body -->
                            </div><!-- end card -->

                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <!--end tab-pane-->
                <div class="tab-pane fade" id="bills" role="tabpanel">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <table id="bills-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>{{ __('ID') }}</th>
                                                <th>{{ __('Due Date') }}</th>
                                                <th>{{ __('End Date') }}</th>
                                                <th>{{ __('Totel') }}</th>
                                                <th>{{ __('Status') }}</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div><!-- end card body -->
                            </div><!-- end card -->

                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <!--end tab-pane-->
            </div>
            <!--end tab-content-->
            
                <div class="modal fade zoomIn" id="editSeller{{ $customer->id }}" tabindex="-1"
                aria-labelledby="addSellerLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="addSellerLabel">{{ __('Edit Customer') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form action="{{ route('c-panel.customers.update', $customer->id) }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <label for="firstnameInput" class="form-label">{{ __('Image') }}</label>
                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <div class="position-relative d-inline-block">
                                                <input type='file'
                                                    onchange="loadFile_image{{ $customer->id }}(image{{ $customer->id }})"
                                                    name="image" id="image{{ $customer->id }}"
                                                    class="@error('image{{ $customer->id }}') is-invalid @enderror"
                                                    style="display:none;" />
                                                <button id="output_image{{ $customer->id }}" type="button" class="bg-light"
                                                    onclick="document.getElementById('image{{ $customer->id }}').click();"
                                                    value="emad"
                                                    style="
                                                        width: 100px;
                                                        height: 100px;
                                                        border-radius: 2px;
                                                        background-repeat: no-repeat;
                                                        background-image: url({{ asset('storage/' . ($customer->image ?? '')) }});
                                                        background-size: cover;
                                                        background-position: center;
                                                        border:none;
                                                        "></button>
                                                <div class="position-absolute top-100 start-100 translate-middle">
                                                    <label for="product-image-input"
                                                        onclick="document.getElementById('image{{ $customer->id }}').click();"
                                                        class="mb-0" title="Select Image">
                                                        <div class="avatar-xs">
                                                            <div
                                                                class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                                <i class="ri-image-fill"></i>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <script>
                                                var loadFile_image{{ $customer->id }} = function(image{{ $customer->id }}) {
                                                    var image{{ $customer->id }} = document.getElementById('output_image{{ $customer->id }}');
                                                    var src = URL.createObjectURL(event.target.files[0]);
                                                    image{{ $customer->id }}.style.backgroundImage = 'url(' + src + ')';
                                                };
                                            </script>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="name" class="form-label">{{ __('Name') }}</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                value="{{ old('name', $customer->name) }}"
                                                placeholder="{{ __('Enter customer name') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="department_id" class="form-label">{{ __('Department') }}</label>
                                            <select class="form-control" name="department_id" id="department_id">
                                                @foreach (App\Models\Department::get() as $department)
                                                    <option @if (old('department_id', $customer->department_id) == $department->id) selected @endif
                                                        value="{{ $department->id }}">{{ $department->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="association" class="form-label">{{ __('Association') }}</label>
                                            <input type="text" class="form-control" id="association" name="association"
                                                value="{{ old('association', $customer->association) }}"
                                                placeholder="{{ __('Enter association name') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                            <input type="text" class="form-control" id="phone" name="phone"
                                                value="{{ old('phone', $customer->phone) }}"
                                                placeholder="{{ __('Enter phone number') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="country" class="form-label">{{ __('Country') }}</label>
                                            <input type="text" class="form-control" id="country" name="country"
                                                value="{{ old('country', $customer->country) }}"
                                                placeholder="{{ __('Enter country') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="city" class="form-label">{{ __('City') }}</label>
                                            <input type="text" class="form-control" id="city" name="city"
                                                value="{{ old('city', $customer->city) }}"
                                                placeholder="{{ __('Enter city') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="website" class="form-label">{{ __('Website') }}</label>
                                            <input type="text" class="form-control" id="website" name="website"
                                                value="{{ old('website', $customer->website) }}"
                                                placeholder="{{ __('Enter website') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="email" class="form-label">{{ __('Email') }}</label>
                                            <input type="email" class="form-control" id="email" name="email"
                                                value="{{ old('email', $customer->email) }}"
                                                placeholder="{{ __('Enter customer email') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="password" class="form-label">{{ __('Password') }}</label>
                                            <input type="password" class="form-control" id="password" name="password"
                                                value="{{ old('password') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="password_confirmation"
                                                class="form-label">{{ __('Confirm Password') }}</label>
                                            <input type="password" class="form-control" id="password_confirmation"
                                                name="password_confirmation" value="{{ old('password_confirmation') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <div class="form-check form-switch form-switch-md">
                                                <input type="checkbox" class="form-check-input" value="1"
                                                    name="status" id="customSwitchsizemd"
                                                    @if (old('status', $customer->status) == '1') checked @endif>
                                                <label for="status"
                                                    class="form-label">{{ __('Activation Status') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-12">
                                        <div class="hstack gap-2 justify-content-end">
                                            <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                                data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                                {{ __('Close') }}</button>
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--end modal-->
        </div>
    </div>
    <!--end col-->
</div>
<!--end row-->
@stop

@section('js')

    <!-- swiper js -->
    <script src="{{ asset('assets/libs/swiper/swiper-bundle.min.js') }}"></script>

    <!-- profile init js -->
    <script src="{{ asset('assets/js/pages/profile.init.js') }}"></script>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>

        $(document).ready(function() {
            $("#services-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '{{ route('c-panel.subscriptions.customer-subscriptions', $customer->id) }}',
                    data: {type: 0}
                },
                columns: [
                    // columns according to JSON
                    {data: 'id', orderable: false},
                    {data: 'name', orderable: false},
                    {data: 'end_date', orderable: false},
                    {data: 'price', orderable: false},
                    {data: 'status', orderable: false},
                    {data: 'status_0', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '{{ __('Show _MENU_') }}',
                    search: '{{ __('Search :') }}',
                    zeroRecords: '{{ __('No matching records found') }}',
                    info: "{{ __('Showing _PAGE_ to _PAGES_') }}",
                    infoEmpty: '{{ __('Show 0 pages') }}',
                    searchPlaceholder: '{{__('Search')}}..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '{{ __('Previous') }}',
                        next: '{{ __('Next') }}'
                    }
                },
            });
            $("#domains-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '{{ route('c-panel.subscriptions.customer-subscriptions', $customer->id) }}',
                    data: {type: 1}
                },
                columns: [
                    // columns according to JSON
                    {data: 'id', orderable: false},
                    {data: 'name', orderable: false},
                    {data: 'end_date', orderable: false},
                    {data: 'price', orderable: false},
                    {data: 'status', orderable: false},
                    {data: 'status_0', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '{{ __('Show _MENU_') }}',
                    search: '{{ __('Search :') }}',
                    zeroRecords: '{{ __('No matching records found') }}',
                    info: "{{ __('Showing _PAGE_ to _PAGES_') }}",
                    infoEmpty: '{{ __('Show 0 pages') }}',
                    searchPlaceholder: '{{__('Search')}}..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '{{ __('Previous') }}',
                        next: '{{ __('Next') }}'
                    }
                },
            });
            $("#bills-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '{{ route('c-panel.bills.customer-bills', $customer->id) }}'
                },
                columns: [
                    // columns according to JSON
                    {data: 'id', orderable: false},
                    {data: 'date', orderable: false},
                    {data: 'end_date', orderable: false},
                    {data: 'totel', orderable: false},
                    {data: 'status', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '{{ __('Show _MENU_') }}',
                    search: '{{ __('Search :') }}',
                    zeroRecords: '{{ __('No matching records found') }}',
                    info: "{{ __('Showing _PAGE_ to _PAGES_') }}",
                    infoEmpty: '{{ __('Show 0 pages') }}',
                    searchPlaceholder: '{{__('Search')}}..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '{{ __('Previous') }}',
                        next: '{{ __('Next') }}'
                    }
                },
            })
        });
    </script>


@stop
