@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __('Customer') }}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Department') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('All Customers') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
@stop

@section('content')

    <form action="{{ route('c-panel.customers.index') }}" method="GET">
        <div class="card">
            <div class="card-header border-0 rounded">
                <div class="row g-2">

                    <div class="col-xl-3">
                        <div class="search-box">
                            <input type="text" name="search" class="form-control search"
                                placeholder="{{ __('Search for customer') }}"> <i class="ri-search-line search-icon"></i>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-xl-2 ms-auto">
                        <div>
                            <select class="form-control" name="department_id" data-choices data-choices-search-false>
                                <option value="">{{ __('Select Department') }}</option>
                                @foreach (App\Models\Department::get() as $department)
                                    <option value="{{ $department->id }}">{{ $department->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-lg-auto">
                        <div class="hstack gap-2">
                            <button type="submit" class="btn btn-danger"><i
                                    class="ri-equalizer-fill me-1 align-bottom"></i>
                                {{ __('Filters') }}</button>
                            @can('createCustomer', App\Models\User::class)
                                <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addSeller"><i
                                        class="ri-add-fill me-1 align-bottom"></i> {{ __('Add Customer') }}</button>
                            @endcan
                        </div>
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->
            </div>
        </div>
    </form>

    <div class="row mt-4">
        @foreach ($customers as $customer)
            <div class="col-xl-3 col-lg-6">
                <div class="card ribbon-box right overflow-hidden">
                    <div class="card-body text-center p-4">
                        <img src="@if($customer->image){{ asset('storage/' . $customer->image) }}@else{{ asset('client-logo.jpeg') }}@endif" alt="" height="45">
                        <h5 class="mb-1 mt-4"><a href="javascript:;" data-bs-toggle="modal"
                                data-bs-target="#editSeller{{ $customer->id }}"
                                class="link-primary">{{ $customer->name }}</a></h5>
                        <p class="text-muted mb-4">{{ $customer->department->name ?? __('حساب جديد') }}</p>

                        <div class="row mt-4">
                            <div class="col-lg-6 border-end-dashed border-end">
                                <h5>0</h5>
                                <span class="text-muted">{{ __('Projects') }}</span>
                            </div>
                            <div class="col-lg-6">
                                <h5>$0</h5>
                                <span class="text-muted">{{ __('Amount owed') }}</span>
                            </div>
                        </div>
                        <div class="mt-4 d-flex">
                            <a href="{{ route('c-panel.customers.show', $customer->id) }}" class="btn btn-light m-1">{{ __('View Details') }}</a>
                            @can('updateCustomer', $customer)
                            <a href="javascript:;" class="btn btn-primary m-1" data-bs-toggle="modal" data-bs-target="#editSeller{{ $customer->id }}"><i class="ri-edit-box-line"></i></a>
                            @endcan
                            @can('deleteCustomer', $customer)
                            <a href="javascript:;" class="btn btn-danger m-1" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $customer->id }}"><i class="ri-delete-bin-6-line"></i></a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        @endforeach
    </div>
    <!--end row-->

    <div class="row g-0 text-center text-sm-start align-items-center mb-3">
        <!-- end col -->
        <div class="col-sm-12">
            {{ $customers->links('vendor.pagination.semantic-ui') }}
        </div><!-- end col -->
    </div><!-- end row -->
    @can('createCustomer', App\Models\User::class)
    <!-- Modal -->
    <div class="modal fade zoomIn" id="addSeller" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSellerLabel">{{ __('Add Customer') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('c-panel.customers.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <label for="firstnameInput" class="form-label">{{ __('Image') }}</label>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <div class="position-relative d-inline-block">
                                        <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                            class="@error('image') is-invalid @enderror" style="display:none;" />
                                        <button id="output_image" type="button" class="bg-light"
                                            onclick="document.getElementById('image').click();" value="emad"
                                            style="
                                                    width: 100px;
                                                    height: 100px;
                                                    border-radius: 2px;
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    border:none;
                                                    "></button>
                                        <div class="position-absolute top-100 start-100 translate-middle">
                                            <label for="product-image-input"
                                                onclick="document.getElementById('image').click();" class="mb-0"
                                                title="Select Image">
                                                <div class="avatar-xs">
                                                    <div
                                                        class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                        <i class="ri-image-fill"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                    <script>
                                        var loadFile_image = function(image) {
                                            var image = document.getElementById('output_image');
                                            var src = URL.createObjectURL(event.target.files[0]);
                                            image.style.backgroundImage = 'url(' + src + ')';
                                        };
                                    </script>
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">{{ __('Name') }}</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        value="{{ old('name') }}" placeholder="{{ __('Enter customer name') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="department_id" class="form-label">{{ __('Department') }}</label>
                                    <select class="form-control" name="department_id" id="department_id">
                                        @foreach (App\Models\Department::get() as $department)
                                            <option @if (old('department_id') == $department->id) selected @endif
                                                value="{{ $department->id }}">{{ $department->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="association" class="form-label">{{ __('Association') }}</label>
                                    <input type="text" class="form-control" id="association" name="association"
                                        value="{{ old('association') }}"
                                        placeholder="{{ __('Enter association name') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="{{ old('phone') }}" placeholder="{{ __('Enter phone number') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="country" class="form-label">{{ __('Country') }}</label>
                                    <input type="text" class="form-control" id="country" name="country"
                                        value="{{ old('country') }}" placeholder="{{ __('Enter country') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="city" class="form-label">{{ __('City') }}</label>
                                    <input type="text" class="form-control" id="city" name="city"
                                        value="{{ old('city') }}" placeholder="{{ __('Enter city') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="website" class="form-label">{{ __('Website') }}</label>
                                    <input type="text" class="form-control" id="website" name="website"
                                        value="{{ old('website') }}" placeholder="{{ __('Enter website') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">{{ __('Email') }}</label>
                                    <input type="email" class="form-control" id="email" name="email"
                                        value="{{ old('email') }}" placeholder="{{ __('Enter customer email') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label">{{ __('Password') }}</label>
                                    <input type="password" class="form-control" id="password" name="password"
                                        value="{{ old('password') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password_confirmation"
                                        class="form-label">{{ __('Confirm Password') }}</label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        name="password_confirmation" value="{{ old('password_confirmation') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                        data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                        {{ __('Close') }}</button>
                                    <button type="submit" class="btn btn-primary"><i
                                            class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end modal-->
    @endcan

    @foreach ($customers as $customer)
        @can('updateCustomer', $customer)
        <!-- Modal -->
        <div class="modal fade zoomIn" id="editSeller{{ $customer->id }}" tabindex="-1"
            aria-labelledby="addSellerLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addSellerLabel">{{ __('Edit Customer') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="{{ route('c-panel.customers.update', $customer->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <label for="firstnameInput" class="form-label">{{ __('Image') }}</label>
                                <div class="col-lg-12">
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block">
                                            <input type='file'
                                                onchange="loadFile_image{{ $customer->id }}(image{{ $customer->id }})"
                                                name="image" id="image{{ $customer->id }}"
                                                class="@error('image{{ $customer->id }}') is-invalid @enderror"
                                                style="display:none;" />
                                            <button id="output_image{{ $customer->id }}" type="button" class="bg-light"
                                                onclick="document.getElementById('image{{ $customer->id }}').click();"
                                                value="emad"
                                                style="
                                                    width: 100px;
                                                    height: 100px;
                                                    border-radius: 2px;
                                                    background-repeat: no-repeat;
                                                    background-image: url({{ asset('storage/' . ($customer->image ?? '')) }});
                                                    background-size: cover;
                                                    background-position: center;
                                                    border:none;
                                                    "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('image{{ $customer->id }}').click();"
                                                    class="mb-0" title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_image{{ $customer->id }} = function(image{{ $customer->id }}) {
                                                var image{{ $customer->id }} = document.getElementById('output_image{{ $customer->id }}');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                image{{ $customer->id }}.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">{{ __('Name') }}</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            value="{{ old('name', $customer->name) }}"
                                            placeholder="{{ __('Enter customer name') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="department_id" class="form-label">{{ __('Department') }}</label>
                                        <select class="form-control" name="department_id" id="department_id">
                                            @foreach (App\Models\Department::get() as $department)
                                                <option @if (old('department_id', $customer->department_id) == $department->id) selected @endif
                                                    value="{{ $department->id }}">{{ $department->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="association" class="form-label">{{ __('Association') }}</label>
                                        <input type="text" class="form-control" id="association" name="association"
                                            value="{{ old('association', $customer->association) }}"
                                            placeholder="{{ __('Enter association name') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                        <input type="text" class="form-control" id="phone" name="phone"
                                            value="{{ old('phone', $customer->phone) }}"
                                            placeholder="{{ __('Enter phone number') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="country" class="form-label">{{ __('Country') }}</label>
                                        <input type="text" class="form-control" id="country" name="country"
                                            value="{{ old('country', $customer->country) }}"
                                            placeholder="{{ __('Enter country') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="city" class="form-label">{{ __('City') }}</label>
                                        <input type="text" class="form-control" id="city" name="city"
                                            value="{{ old('city', $customer->city) }}"
                                            placeholder="{{ __('Enter city') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="website" class="form-label">{{ __('Website') }}</label>
                                        <input type="text" class="form-control" id="website" name="website"
                                            value="{{ old('website', $customer->website) }}"
                                            placeholder="{{ __('Enter website') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">{{ __('Email') }}</label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            value="{{ old('email', $customer->email) }}"
                                            placeholder="{{ __('Enter customer email') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="password" class="form-label">{{ __('Password') }}</label>
                                        <input type="password" class="form-control" id="password" name="password"
                                            value="{{ old('password') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="password_confirmation"
                                            class="form-label">{{ __('Confirm Password') }}</label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" value="{{ old('password_confirmation') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <div class="form-check form-switch form-switch-md">
                                            <input type="checkbox" class="form-check-input" value="1"
                                                name="status" id="customSwitchsizemd"
                                                @if (old('status', $customer->status) == '1') checked @endif>
                                            <label for="status"
                                                class="form-label">{{ __('Activation Status') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                            data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                            {{ __('Close') }}</button>
                                        <button type="submit" class="btn btn-primary"><i
                                                class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end modal-->
        @endcan

        @can('deleteCustomer', $customer)
        <!-- Delete Modal -->
        <div class="modal fade zoomIn" id="delete-item-{{ $customer->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                            id="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <form action=" {{ route('c-panel.customers.destroy', $customer->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <div class="mt-2 text-center">
                                <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop"
                                    colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px">
                                </lord-icon>
                                <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                    <h4>{{ __('Are you Sure ?') }}</h4>
                                    <p class="text-muted mx-4 mb-0">
                                        {{ __('Are you Sure You want to Remove this Record ?') }}</p>
                                </div>
                            </div>
                            <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                <button type="button" class="btn w-sm btn-light"
                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                <button type="submit" class="btn w-sm btn-danger "
                                    id="delete-record">{{ __('Yes, Delete It!') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end delete modal -->
        @endcan
    @endforeach

@stop

@section('js')
    {{-- <!-- ckeditor -->
    <script src="{{ asset('assets/libs/@ckeditor/ckeditor5-build-classic/build/ckeditor.js') }}"></script>

    <!-- dropzone js -->
    <script src="{{ asset('assets/libs/dropzone/dropzone-min.js') }}"></script>
    <script src="{{ asset('assets/js/pages/ecommerce-product-create.init.js') }}"></script> --}}


@stop
