<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $bill->id }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&amp;display=swap" rel="stylesheet">
</head>
<body @if(\LaravelLocalization::getCurrentLocale() == 'ar') dir="rtl" @endif>
    <table class="body-wrap" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; width: 100%; background-color: transparent; margin: 0;">
        <tr style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;">
            <td style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0;" valign="top"></td>
            <td class="container" width="600" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto;" valign="top">
                <div class="content" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; max-width: 600px; display: block; margin: 0 auto; padding: 20px;">
                    <table class="main" width="100%" cellpadding="0" cellspacing="0" itemprop="action" itemscope itemtype="http://schema.org/ConfirmAction" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; border-radius: 3px; margin: 0; border: none;">
                        <tr style="font-family: 'Roboto', sans-serif; font-size: 14px; margin: 0;">
                            <td class="content-wrap" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; color: #495057; font-size: 14px; vertical-align: top; margin: 0;padding: 30px; box-shadow: 0 3px 15px rgba(30,32,37,.06); ;border-radius: 7px; background-color: #fff;" valign="top">
                                <meta itemprop="name" content="Confirm Email" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;" />
                                <table width="100%" cellpadding="0" cellspacing="0" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;"  @if(\LaravelLocalization::getCurrentLocale() == 'ar') dir="rtl" @endif>
                                    <tr style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;">
                                        <td class="content-block" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 24px; vertical-align: top; margin: 0; padding: 0 0 10px; text-align: center;" valign="top">
                                            <h4 style="font-family: 'Roboto', sans-serif; margin-bottom: 10px; font-weight: 600;">{{ $title }}</h5>
                                        </td>
                                    </tr>
                                    <tr style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;">
                                        <td class="content-block" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 15px; vertical-align: top; margin: 0; padding: 0 0 12px;" valign="top">
                                            <h5 style="font-family: 'Roboto', sans-serif; margin-bottom: 3px;">{{ __('Hey,') }} {{ $bill->customer->name }}</h5>
                                            <p style="font-family: 'Roboto', sans-serif; margin-bottom: 8px; color: #878a99;">{{ __('Your subscription will expire soon') }}.</p>
                                        </td>
                                    </tr>
                                    <tr style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;">
                                        <td class="content-block" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 15px; vertical-align: top; margin: 0; padding: 0 0 18px;" valign="top">
                                            <table style="width:100%;"  @if(\LaravelLocalization::getCurrentLocale() == 'ar') dir="rtl" @endif>
                                                <tbody>
                                                    <tr style="text-align: left;" >
                                                        <th style="padding: 5px; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">
                                                            <p style="color: #878a99; font-size: 13px; margin-bottom: 2px; font-weight: 400;">{{ __('Bill Number') }}</p>
                                                            <span>{{ $bill->id }}</span>
                                                        </th>
                                                        <th style="padding: 5px; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">
                                                            <p style="color: #878a99; font-size: 13px; margin-bottom: 2px; font-weight: 400;">{{ __('Due Date') }}</p>
                                                            <span>{{ $bill->date }}</span>
                                                        </th>
                                                        <th style="padding: 5px; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">
                                                            <p style="color: #878a99; font-size: 13px; margin-bottom: 2px; font-weight: 400;">{{ __('End Date') }}</p>
                                                            <span>{{ $bill->end_date }}</span>
                                                        </th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;">
                                        <td class="content-block" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 15px; vertical-align: top; margin: 0; padding: 0 0 12px;" valign="top">
                                            <h6 style="font-family: 'Roboto', sans-serif; font-size: 15px; text-decoration-line: underline;margin-bottom: 15px;">{{ __('Bill Details') }}:</h6>
                                            <table style="width:100%;" cellspacing="0" cellpadding="0"  @if(\LaravelLocalization::getCurrentLocale() == 'ar') dir="rtl" @endif>
                                                <thead style="text-align: left;">
                                                    <th style="padding: 8px;border-bottom: 1px solid #e9ebec; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">{{ __('Service Details') }}</th>
                                                    <th style="padding: 8px;border-bottom: 1px solid #e9ebec; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">{{ __('Price') }}</th>
                                                    <th style="padding: 8px;border-bottom: 1px solid #e9ebec; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">{{ __('Discount') }} %</th>
                                                    <th style="padding: 8px;border-bottom: 1px solid #e9ebec; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">{{ __('Tax') }} %</th>
                                                    <th style="padding: 8px;border-bottom: 1px solid #e9ebec; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">{{ __('Total') }}</th>
                                                </thead>
                                                <tbody>
                                                    @foreach ($bill->services as $item)
                                                    <tr>
                                                        <td style="padding: 8px; font-size: 13px;">
                                                            {{ $item->name }}
                                                        </td>
                                                        <td style="padding: 8px; font-size: 13px;">
                                                            {{ $item->price }}
                                                        </td>
                                                        <td style="padding: 8px; font-size: 13px;">
                                                            {{ $item->discount }}
                                                        </td>
                                                        <td style="padding: 8px; font-size: 13px;">
                                                            {{ $item->tax }}
                                                        </td>
                                                        <td style="padding: 8px; font-size: 13px;">
                                                            {{ $item->totel }}
                                                        </td>
                                                    </tr>
                                                    @endforeach

                                                    <tr>
                                                        <td colspan="3" style="padding: 8px; font-size: 13px; text-align: end;border-top: 1px solid #e9ebec;">
                                                            {{ __('Total Amount') }}
                                                        </td>
                                                        <td></td>
                                                        <th style="padding: 8px; font-size: 13px;border-top: 1px solid #e9ebec; @if(\LaravelLocalization::getCurrentLocale() == 'ar') text-align: right; @endif">
                                                            {{ $bill->totel }}
                                                        </th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;">
                                        <td class="content-block" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: 15px; vertical-align: top; margin: 0; padding: 0 0 0px;" valign="top">
                                            <h6 style="font-family: 'Roboto', sans-serif; font-size: 14px; margin-bottom: 0px; text-align: end;">{{ __('Thank you!') }}</h6>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>

                    <div style="margin-top: 32px; text-align: center;">
                        <a href="https://crm.divvat.com/client/login" target="_blank" itemprop="url" style="font-family: 'Roboto', sans-serif; box-sizing: border-box; font-size: .8125rem; color: #FFF; text-decoration: none; font-weight: 400; text-align: center; cursor: pointer; display: inline-block; border-radius: .25rem; text-transform: capitalize; background-color: #405189; margin: 0; border-color: #405189; border-style: solid; border-width: 1px; padding: .5rem .9rem;">{{ __('Dashboard') }}</a>
                    </div>
                    <div style="text-align: center; margin: 28px auto 0px auto;">
                        <p style="font-family: 'Roboto', sans-serif; font-size: 14px;color: #98a6ad; margin: 0px;">&copy; {{ __('تشفير ICO. كل الحقوق محفوظة') }}</p>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <!-- end table -->
</body>
</html>
