<?php

namespace App\Policies;

use App\Models\Domin;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class DominPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        return auth()->check() && (in_array(16, $user->permissions()) || in_array(17, $user->permissions()) || in_array(18, $user->permissions()) || in_array(19, $user->permissions()));
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        return auth()->check() && in_array(17, $user->permissions());
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Department  $department
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, Domin $domin)
    {
        return auth()->check() && in_array(18, $user->permissions());
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Department  $department
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, Domin $domin)
    {
        return auth()->check() && in_array(19, $user->permissions());
    }
    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Domin  $domin
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Domin $domin)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Domin  $domin
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Domin $domin)
    {
        //
    }
}
